const { ipcRenderer } = require('electron');

const resultElem = document.getElementById('status');

async function checkAntivirusStatus() {
    const res = await ipcRenderer.invoke('check-antivirus');

    if (res.status === 'error') {
        resultElem.textContent = 'Błąd: ' + res.message;
    } else if (res.status === 'off') {
        resultElem.textContent = 'Brak aktywnego antywirusa. Zamykanie...';
        // Program sam się zamknie z main.js
    } else if (res.status === 'on') {
        resultElem.textContent = 'Aktywny antywirus: ' + res.antivirus.join(', ');
    } else {
        resultElem.textContent = 'Nieznany stan: ' + res.message;
    }
}

document.getElementById('disable').addEventListener('click', () => {
    ipcRenderer.invoke('open-defender-settings');
    document.getElementById('status').textContent = 'Otwieranie ustawień ochrony...';
});



// 🔁 Sprawdzaj co 1 sekundę
setInterval(checkAntivirusStatus, 1000);

// 🔄 Dodatkowo uruchom od razu
checkAntivirusStatus();
